
window.addEventListener('load', eventWindowLoaded, false);
function eventWindowLoaded() {
   canvasApp();

}

function canvasSupport () {
     return Modernizr.canvas;
}

/* This is the programme */
function canvasApp() {

  if (!canvasSupport()) {
          return;
        }
		
/* Sets up listeners to check for the controls being changed */
   
   formElement = document.getElementById("ideal");
   formElement.addEventListener('change', idealchanged, false);

   formElement = document.getElementById("bluemolecules");
   formElement.addEventListener('change', bluechanged, false);
   
   formElement = document.getElementById("yellowmolecules");
   formElement.addEventListener('change', yellowchanged, false);


/* Draws the game screen */
  function  drawScreen () {

      context.fillStyle = '#EEEEEE';
      context.fillRect(0, 0, theCanvas.width, theCanvas.height);
      //Box
      context.strokeStyle = '#000000';
      context.strokeRect(1,  1, theCanvas.width-2, theCanvas.height-2);
      
      loadballs();
      update();
      testWalls();
      pressureaverage();
      if (idealvar)
      {}
      else
      {
    	  collide();
      }      
      render();
      saveballs();
   }

/* Calculates next position for each ball */
   function update() {
      for (var i = 0; i <balls.length; i++) {
         ball = balls[i];
         ball.nextx = (ball.x += ball.velocityx);
         ball.nexty = (ball.y += ball.velocityy);
      }

   }
   
/* Load blue and/or yellow balls */
	function loadballs() {
	balls.length = 0;
	if (bluemoleculesvar)
	{
		balls = balls.concat(blueballs);
	}
	
	if (yellowmoleculesvar)
	{
		balls = balls.concat(yellowballs);
	}
	}
	
/* Save blue and/or yellow balls */
	function saveballs() {
		if (bluemoleculesvar)
		{
			blueballs = balls.slice(0, numBalls/2);
			if (yellowmoleculesvar)
			{
				yellowballs = balls.slice(numBalls/2, numBalls);
			}
		}
		else if (yellowmoleculesvar)
		{
			yellowballs = balls.slice(0, numBalls/2);
		}
	}
		
/* Checks if any balls will hit the walls */
   function testWalls() {
      var ball;
      var testBall;
      wallhitsthisloop = 0;

      for (var i = 0; i <balls.length; i++) {
         ball = balls[i];

         if (ball.nextx+ball.radius > theCanvas.width) {
            ball.velocityx = ball.velocityx*-1;
            ball.nextx = theCanvas.width - ball.radius;
            wallhitsthisloop++;

         } else if (ball.nextx-ball.radius < 0 ) {
            ball.velocityx = ball.velocityx*-1;
            ball.nextx =ball.radius;
            wallhitsthisloop++;

         } else if (ball.nexty+ball.radius > theCanvas.height ) {
            ball.velocityy = ball.velocityy*-1;
            ball.nexty = theCanvas.height - ball.radius;
            wallhitsthisloop++;

         } else if(ball.nexty-ball.radius < 0) {
            ball.velocityy = ball.velocityy*-1;
            ball.nexty = ball.radius;
            wallhitsthisloop++;
         }
      }
   }
   
   function pressureaverage() {
   var wallhitsaveragevalue;
   if (wallhits.length < wallhitsaverage)
   {
		wallhits.push(wallhitsthisloop);
		}
	else
	{
		wallhits.splice (0,1);
		wallhits.push(wallhitsthisloop);
	}
	
	var sum = 0;
	for( var i = 0; i < wallhits.length; i++ ){
	    sum += wallhits[i]
	}

	var avg = sum/wallhits.length;
	
	wallhitsaveragevalue = Math.round(avg * wallhitsaverage / 20);
	
	document.getElementById("pressurereadout").innerHTML=(wallhitsaveragevalue);
	
	}
	

/* Checks if any balls have collided */
    function collide() {
       var ball;
       var testBall;
       for (var i = 0; i <balls.length; i++) {
           ball = balls[i];
           for (var j = i+1; j < balls.length; j++) {
                 testBall = balls[j];
                if (hitTestCircle(ball,testBall)) {
                    collideBalls(ball,testBall);
                 }
              }
        }
     }

/* Draws the balls */	 
	function render() {
      var ball;
 //     context.fillStyle = "#000000";
      for (var i = 0; i <balls.length; i++) {
         ball = balls[i];
         ball.x = ball.nextx;
         ball.y = ball.nexty;
		 context.fillStyle = ball.colour;
         context.beginPath();
         context.arc(ball.x,ball.y,ball.radius,0,Math.PI*2,true);
         context.closePath();
         context.fill();
      }

   }

/* Checks to see if two balls have collided */
   function hitTestCircle(ball1,ball2) {
       var retval = false;
       var dx = ball1.nextx - ball2.nextx;
       var dy = ball1.nexty - ball2.nexty;
       var distance = (dx * dx + dy * dy);
       if (distance <= (ball1.radius + ball2.radius) *
                       (ball1.radius + ball2.radius) )
       {
              retval = true;
       }
       return retval;
     }

/* Calculates new velocities when two balls collide */
   function collideBalls(ball1,ball2) {

      var dx = ball1.nextx - ball2.nextx;
      var dy = ball1.nexty - ball2.nexty;

      var collisionAngle = Math.atan2(dy, dx);

      var speed1 = Math.sqrt(ball1.velocityx * ball1.velocityx +
          ball1.velocityy * ball1.velocityy);
      var speed2 = Math.sqrt(ball2.velocityx * ball2.velocityx +
          ball2.velocityy * ball2.velocityy);

      var direction1 = Math.atan2(ball1.velocityy, ball1.velocityx);
      var direction2 = Math.atan2(ball2.velocityy, ball2.velocityx);

      var velocityx_1 = speed1 * Math.cos(direction1 - collisionAngle);
      var velocityy_1 = speed1 * Math.sin(direction1 - collisionAngle);
      var velocityx_2 = speed2 * Math.cos(direction2 - collisionAngle);
      var velocityy_2 = speed2 * Math.sin(direction2 - collisionAngle);

      var final_velocityx_1 = ((ball1.mass - ball2.mass) * velocityx_1 +
         (ball2.mass + ball2.mass) * velocityx_2)/(ball1.mass + ball2.mass);
      var final_velocityx_2 = ((ball1.mass + ball1.mass) * velocityx_1 +
         (ball2.mass - ball1.mass) * velocityx_2)/(ball1.mass + ball2.mass);

      var final_velocityy_1 = velocityy_1;
      var final_velocityy_2 = velocityy_2;

      ball1.velocityx = Math.cos(collisionAngle) * final_velocityx_1 +
          Math.cos(collisionAngle + Math.PI/2) * final_velocityy_1;
      ball1.velocityy = Math.sin(collisionAngle) * final_velocityx_1 +
          Math.sin(collisionAngle + Math.PI/2) * final_velocityy_1;
      ball2.velocityx = Math.cos(collisionAngle) * final_velocityx_2 +
          Math.cos(collisionAngle + Math.PI/2) * final_velocityy_2;
      ball2.velocityy = Math.sin(collisionAngle) * final_velocityx_2 +
          Math.sin(collisionAngle + Math.PI/2) * final_velocityy_2;

      ball1.nextx = (ball1.nextx += ball1.velocityx);
      ball1.nexty = (ball1.nexty += ball1.velocityy);
      ball2.nextx = (ball2.nextx += ball2.velocityx);
      ball2.nexty = (ball2.nexty += ball2.velocityy);
   }
   
   function increaseBrightness(hex, percent){
	    // strip the leading # if it's there
	    hex = hex.replace(/^\s*#|\s*$/g, '');
	
	    // convert 3 char codes --> 6, e.g. `E0F` --> `EE00FF`
	    if(hex.length == 3){
	        hex = hex.replace(/(.)/g, '$1$1');
	    }
	
	    var r = parseInt(hex.substr(0, 2), 16),
	        g = parseInt(hex.substr(2, 2), 16),
	        b = parseInt(hex.substr(4, 2), 16);
	
	    return "#" +
	       ((0|(1<<8) + r + (256 - r) * percent / 100).toString(16)).substr(1) +
	       ((0|(1<<8) + g + (256 - g) * percent / 50).toString(16)).substr(1) +
	       ((0|(1<<8) + b + (256 - b) * percent / 50).toString(16)).substr(1);
	}

/* Variables used in the game (declared within canvasApp function so all sub-routines can access them) */
   var numBalls = 400 ;
   var sizeRange = 1;
   var sizeMin = 8;
   var maxSpeed = 5;
   var basecolour = "#000000";
   var tempballcolour;
   var balls = new Array();
   var blueballs = new Array();
   var yellowballs = new Array();
   var tempBall;
   var tempX;
   var tempY;
   var tempSpeed;
   var tempAngle;
   var tempRadius;
   var tempMass;
   var tempRadians;
   var tempvelocityx;
   var tempvelocityy;
   var attracttosidevar;
   var idealvar = true;
   var bluemoleculesvar = true;
   var yellowmoleculesvar = true;
   var wallhits = new Array();
   var wallhitsaverage = 200;
   var wallhitsthisloop = 0;

   theCanvas = document.getElementById("canvasOne");
   context = theCanvas.getContext("2d");

/* This for loop generates the balls */
function initializeballs () {
balls.length = 0;
blueballs.length = 0;
yellowballs.length = 0;

   for (var i = 0; i < numBalls/2; i++) {
      tempRadius = Math.floor(Math.random()*sizeRange)+sizeMin;
      var placeOK = false;
      while (!placeOK) {
         tempX = tempRadius*3 + (Math.floor(Math.random()*theCanvas.width)
            -tempRadius*3);
			tempballcolour = "#FFAA00";

         tempY = tempRadius*3 + (Math.floor(Math.random()*theCanvas.height)
            -tempRadius*3);
			tempSpeed = maxSpeed;
         tempAngle = Math.floor(Math.random()*360);
         tempRadians = tempAngle * Math.PI/ 180;
         tempvelocityx = Math.cos(tempRadians) * tempSpeed;
         tempvelocityy = Math.sin(tempRadians) * tempSpeed;
		 tempMass = tempRadius * tempRadius;

         tempBall = {x:tempX,y:tempY, nextx:tempX, nexty:tempY, radius:tempRadius,
             speed:tempSpeed, angle:tempAngle, velocityx:tempvelocityx,
             velocityy:tempvelocityy, mass:tempMass, colour:tempballcolour};
         placeOK = canStartHere(tempBall);
		 console.log(placeOK);
      }
      yellowballs.push(tempBall);
   }
   
    for (var i = numBalls/2; i < numBalls; i++) {
      tempRadius = Math.floor(Math.random()*sizeRange)+sizeMin;
      var placeOK = false;
      while (!placeOK) {
			tempX = tempRadius*3 + (Math.floor(Math.random()*theCanvas.width)
            -tempRadius*3);
			tempballcolour = "#00BCF5";

         tempY = tempRadius*3 + (Math.floor(Math.random()*theCanvas.height)
            -tempRadius*3);
			tempSpeed = maxSpeed;
         tempAngle = Math.floor(Math.random()*360);
         tempRadians = tempAngle * Math.PI/ 180;
         tempvelocityx = Math.cos(tempRadians) * tempSpeed;
         tempvelocityy = Math.sin(tempRadians) * tempSpeed;
		 tempMass = tempRadius * tempRadius;

         tempBall = {x:tempX,y:tempY, nextx:tempX, nexty:tempY, radius:tempRadius,
             speed:tempSpeed, angle:tempAngle, velocityx:tempvelocityx,
             velocityy:tempvelocityy, mass:tempMass, colour:tempballcolour};
         placeOK = canStartHere(tempBall);
		 console.log(placeOK);
      }
      blueballs.push(tempBall);
   }
   }

/* This makes sure that two balls don't start in the same place */
   function canStartHere(ball) {
      var retval = true;
      for (var i = 0; i <balls.length; i++) {
         if (hitTestCircle(ball, balls[i])) {
            retval = false;
         }
      }
      return retval;
   }

/* This function runs the game */
   function gameLoop() {
     window.setTimeout(gameLoop, 50);
     drawScreen()
   }
	  
   function idealchanged(e) {
      var target = e.target;
      idealvar = target.checked;
      wallhits.length = 0;
   }
   
   function bluechanged(e) {
      var target = e.target;
      bluemoleculesvar = target.checked;
      wallhits.length = 0;
   }

   function yellowchanged(e) {
      var target = e.target;
      yellowmoleculesvar = target.checked;
      wallhits.length = 0;
   }

/* This calls the function to run the game */
initializeballs();
   gameLoop();
}



